rem *** OCTOPUS 600,900, EyeSuite ***
rem *** This batch file is called from PeriData and starts the instrument control program (EYESUITE.exe)

rem *** OPTIONAL - copy the GDT file to another directory
rem *** if the perimeter app has another GDT import directory
REM copy  C:\PeriDataExchange\Gdt2Perimeter\PERIPERI.GDT  <target path>

rem *** SETTINGS
set peri="EyeSuite"
rem get the call specs
set perilongold="C:\Program Files (X86)\Haag-Streit\EyeSuite\EyeSuite.exe"
set perilongnew="C:\Program Files\Haag-Streit\EyeSuite\EyeSuiteLauncher.exe"
if exist %perilongold% (set perilong=%perilongold%)
if exist %perilongnew% (set perilong=%perilongnew%)
if not exist %perilong% exit

rem *** START IF NOT RUNNING
rem *** 1.line TASKLIST - result is written to file (exe does not return an errorlevel)
rem *** 2.line FINDSTR - result is returned as errorlevel
rem *** 3.line set the variable NOTRUNNING (errorlevel is temporarily, lost after 1 line)
rem *** 4.line if NOT running > start "perilong"
%SystemRoot%\System32\tasklist.exe /FI "imagename eq %peri%.exe" > %USERPROFILE%\ergebnis.txt
%SystemRoot%\System32\findstr.exe /i /c:"%peri%.exe" %USERPROFILE%\ergebnis.txt 
set notrunning=%errorlevel%
if %notrunning% gtr 0 start " " %perilong%

rem *** INSTRUMENT PROGRAM WINDOW ON TOP - last command starts second batch
C:\PeriDataExchange\Gdt2Perimeter\WindowOnTop.bat %peri%

